import { View, Text, TouchableWithoutFeedback } from "react-native";
import React from "react";
import { productDetailsStyle } from "../ProductDetailsStyle";
import CustomSpinner from "../../../../Utilities/CustomSpinner/CustomSpinner";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";
import AddToCart from "../../../../../assets/svgs/product details/addtocart.svg";
import useLangTranslation from "../../../../../hooks/useLangTranslation";
import CustomSVG from "../../../../../src/components/CustomSVG/CustomSVG";

const AddToCartBtn = ({ disableBtn, cartLoading, handleAddToCart, width }) => {
    const { trans } = useLangTranslation();
    return (
        <TouchableWithoutFeedback
            disabled={disableBtn}
            onPress={() => (cartLoading ? {} : handleAddToCart())}
        >
            <View
                style={productDetailsStyle.addToCartContainer(disableBtn, width)}
            >
                {cartLoading ? (
                    <CustomSpinner
                        filePath={require("../../../../../assets/lottie/loader2.json")}
                        size={{
                            width: dpr(60),
                            height: dpr(50),
                        }}
                    />
                ) : (
                    <View style={productDetailsStyle.addToCart}>
                        <CustomSVG svgIcon={AddToCart} height={dpr(22)} width={dpr(18)} />
                        <Text style={productDetailsStyle.cartBtnText}>
                            {trans("Add to Cart")}
                        </Text>
                    </View>
                )}
            </View>
        </TouchableWithoutFeedback>
    );
};

export default AddToCartBtn;
